/*
	Copyright 2006-2026 The QElectroTech Team
	This file is part of QElectroTech.

	QElectroTech is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the License, or
	(at your option) any later version.

	QElectroTech is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with QElectroTech.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef CHANGETERMINALSTRIPCOLOR_H
#define CHANGETERMINALSTRIPCOLOR_H

#include <QUndoCommand>
#include <QSharedPointer>
#include <QColor>

class TerminalStripBridge;

/**
 * @brief The ChangeTerminalStripColor class
 */
class ChangeTerminalStripColor : public QUndoCommand
{
	public:
		ChangeTerminalStripColor(QSharedPointer<TerminalStripBridge> bridge,
								 const QColor &color,
								 QUndoCommand *parent = nullptr);

		void redo() override;
		void undo() override;

	private:
		QSharedPointer<TerminalStripBridge> m_bridge;
		QColor m_old_color, m_new_color;
};

#endif // CHANGETERMINALSTRIPCOLOR_H
